﻿//////////////////////////////////////////////
// Sampler.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

#include "../Resources/Resource.h"

#include "Enums/ComparisonFunction.h"
#include "Enums/Filter.h"
#include "Enums/TextureAddressMode.h"

// nkExport
#include <NilkinsExport/Exportable/Exportable.h>

// nkMemory
#include <NilkinsMemory/Containers/StringView.h>

#include <NilkinsMemory/Pointers/UniquePtr.h>

/// Class ------------------------------------
	
namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT Sampler : public Resource, public nkExport::Exportable
	{
		public :

			// Destructor
			virtual ~Sampler () ;

			// Getters
			virtual FILTER getFiltering () const = 0 ;
			virtual TEXTURE_ADDRESS_MODE getAddressModeU () const = 0 ;
			virtual TEXTURE_ADDRESS_MODE getAddressModeV () const = 0 ;
			virtual TEXTURE_ADDRESS_MODE getAddressModeW () const = 0 ;
			virtual COMPARISON_FUNCTION getComparisonFunction () const = 0 ;
			virtual float getMipBias () const = 0 ;
			virtual unsigned int getMaxAnisotropy () const = 0 ;
			virtual float getMinLodLevel () const = 0 ;
			virtual float getMaxLodLevel () const = 0 ;
			virtual float getBorderColorR () const = 0 ;
			virtual float getBorderColorG () const = 0 ;
			virtual float getBorderColorB () const = 0 ;
			virtual float getBorderColorA () const = 0 ;
			nkMemory::StringView getFilteringAsString () const ;
			nkMemory::StringView getAddressModeUAsString () const ;
			nkMemory::StringView getAddressModeVAsString () const ;
			nkMemory::StringView getAddressModeWAsString () const ;
			nkMemory::StringView getComparisonFuncAsString () const ;

			// Setters
			virtual void setBorderColors (float r, float g, float b, float a) = 0 ;
			virtual void setBorderColorR (float value) = 0 ;
			virtual void setBorderColorG (float value) = 0 ;
			virtual void setBorderColorB (float value) = 0 ;
			virtual void setBorderColorA (float value) = 0 ;
			virtual void setLodLevels (float min, float max) = 0 ;
			virtual void setMaxAnisotropy (unsigned int value) = 0 ;
			virtual void setMipMapBias (float value) = 0 ;
			virtual void setFilterMethod (FILTER value) = 0 ;
			virtual void setAddressModeU (TEXTURE_ADDRESS_MODE value) = 0 ;
			virtual void setAddressModeV (TEXTURE_ADDRESS_MODE value) = 0 ;
			virtual void setAddressModeW (TEXTURE_ADDRESS_MODE value) = 0 ;
			virtual void setComparisonFunction (COMPARISON_FUNCTION value) = 0 ;
			virtual void resetToDefault () = 0 ;
			void setFilterMethodFromString (nkMemory::StringView value) ;
			void setAddressModeUFromString (nkMemory::StringView value) ;
			void setAddressModeVFromString (nkMemory::StringView value) ;
			void setAddressModeWFromString (nkMemory::StringView value) ;
			void setComparisonFuncFromString (nkMemory::StringView value) ;

			// Import / Export
			virtual void exportClassToTree (nkExport::Node* rootNode) override ;
			virtual void importClassFromTree (nkExport::Node* rootNode) override ;

		public :

			// Statics
			static nkMemory::UniquePtr<Sampler> create (System* system = nullptr) ;

		protected :

			// Functions
			// Constructor
			Sampler (System* system) noexcept ;
	} ;
}